USE [DownloadStatistics]
GO

/****** Object:  StoredProcedure [dbo].[UpdateProjectPopularity]    Script Date: 9/17/2014 12:01:33 PM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO




-- =============================================
-- Author:		<James Davis>
-- Create date: <2013/06/10>
-- Description:	<Replaces spUpdateProjectv2>
-- =============================================
ALTER PROCEDURE [dbo].[UpdateProjectPopularity] 
	
AS
DECLARE @currDate varchar(25), @startDate varchar(25), @index int, @decayRate decimal(19,9), @gameId int, @dayOfMonth int, @controlCheck int
BEGIN
	SET NOCOUNT ON;
	SELECT @currDate = CONVERT(VARCHAR(25), GETUTCDATE(),101), @index = 0, @decayRate = 2.2;
	-- Thirty day Files by project count update,  THIS should be 
	WITH ThirtyDayCounts (ProjectID, UniqueDownloadsLastThirtyDays) AS
	(
		SELECT F.ProjectID,COUNT(DISTINCT R.IpAddress) AS UniqueDownloadsLastThirtyDays
		FROM [dbo].[Record] AS R
		LEFT JOIN [dbo].[File] AS F ON R.FileID = F.ID
		WHERE R.[Date] >= DATEADD(DAY, -31, @currDate) and R.[Date] < @currDate AND F.ProjectID IS NOT NULL
		GROUP BY F.ProjectID
		UNION 
		SELECT F.ProjectID, 0
		FROM [dbo].[File] F
		WHERE F.ProjectID NOT IN (SELECT F.ProjectID FROM [dbo].[Record] AS R
			LEFT JOIN [dbo].[File] AS F ON R.FileID = F.ID
			WHERE R.[Date] >= DATEADD(DAY, -31, @currDate) and R.[Date] < @currDate AND F.ProjectID IS NOT NULL)

	)
	MERGE [dbo].[Project] AS TARGET
	USING ThirtyDayCounts AS SOURCE
	ON (TARGET.ID = SOURCE.ProjectID)
	WHEN MATCHED and TARGET.UniqueDownloadsLastThirtyDays != SOURCE.UniqueDownloadsLastThirtyDays THEN
		UPDATE SET TARGET.UniqueDownloadsLastThirtyDays = SOURCE.UniqueDownloadsLastThirtyDays,
			TARGET.DatePopularityModified = GETUTCDATE();

-- POPULARITY SCORE STUFF
	
	SELECT @dayOfMonth = DAY(@currDate);
	
	IF @dayOfMonth = 1
	BEGIN
		-- first check to see if this has been done already just incase we are running this manuall for a second time on the first of the month
		SELECT @controlCheck = (SELECT TOP 1 ID FROM [dbo].[ProjectDownloadsByDateRange] WHERE FromDate = CONVERT(VARCHAR(25), DATEADD(mm,  - 1, @currDate), 101));
		IF @controlCheck is null
		BEGIN
			EXEC InsertMonthIntoProjectDownloadByDateRange; 
		END
 	END
	IF OBJECT_ID('tempdb..#tempProjectPopularity') IS NOT NULL
    DROP TABLE #tempProjectPopularity
	CREATE TABLE #tempProjectPopularity (ProjectID int, GameID int, UniqueDownloads int, PopularityScore Decimal(19,9), PopularityRank int, GamePopularityRank int);
	CREATE NONCLUSTERED INDEX IX_ProjectID ON #tempProjectPopularity (ProjectID);
	CREATE NONCLUSTERED INDEX IX_GameID ON #tempProjectPopularity (GameID) INCLUDE (ProjectID, PopularityScore);

	INSERT INTO #tempProjectPopularity
	SELECT ID, GameID, UniqueDownloadsLastThirtyDays,0,0,0 FROM Project with (nolock)

-- CALCULATE THE POPULARITY SCORE
	MERGE #tempProjectPopularity AS TARGET
	USING #tempProjectPopularity AS SOURCE
	ON (TARGET.ProjectID = SOURCE.ProjectID)
	WHEN MATCHED THEN UPDATE SET PopularityScore = SOURCE.UniqueDownloads / EXP(@index / @decayRate);

	SET @index = 1;
	WHILE(@index < 7)
	BEGIN
		SELECT @startDate = CONVERT(VARCHAR(25), DATEADD(dd, -(DAY(@currDate) - 1), @currDate), 101);
		SELECT @startDate = CONVERT(VARCHAR(25), DATEADD(mm,  - 1, @startDate), 101);
		WITH tempy (ProjectID, UniqueTotalDownloads) AS
		(
			SELECT ProjectID, UniqueTotalDownloads
			FROM [dbo].[ProjectDownloadsByDateRange]
			WHERE FromDate = @startDate
		)
		MERGE #tempProjectPopularity AS TARGET
		USING tempy AS SOURCE
		ON (TARGET.ProjectID = SOURCE.ProjectID)
		WHEN MATCHED THEN
			UPDATE SET TARGET.PopularityScore = TARGET.PopularityScore + (SOURCE.UniqueTotalDownloads / EXP(@index / @decayRate));

		SET @currDate = @startDate;
		SET @index = @index + 1;
	END

-- CALCULATE THE POPULARITY RANKING

	;WITH popRank (ProjectID, GameID, PopularityRank) AS
	(
	SELECT ProjectID, GameID, ROW_NUMBER() OVER(ORDER BY PopularityScore DESC) AS PopularityRank  FROM #tempProjectPopularity
	)
	MERGE #tempProjectPopularity AS TARGET
	USING popRank AS SOURCE
	ON (TARGET.ProjectID = SOURCE.ProjectID)
	WHEN MATCHED THEN 
		UPDATE SET 
			TARGET.PopularityRank = SOURCE.PopularityRank;
	
-- CALCULATE THE GAME POPULARITY RANKING
	IF OBJECT_ID('tempdb..#tempProjectGamePopularityRank') IS NOT NULL
    DROP TABLE #tempProjectGamePopularityRank
	CREATE TABLE #tempProjectGamePopularityRank (ProjectID int, GameID int, GamePopularityRank int);
	
	-- Iterate through the gameIds
	DECLARE gameIds CURSOR FOR SELECT DISTINCT GameID FROM Project;
	OPEN gameIds;
	FETCH NEXT FROM gameIds INTO @gameId;
	WHILE @@FETCH_STATUS = 0
	BEGIN
		INSERT INTO #tempProjectGamePopularityRank
		SELECT ProjectID, GameID, ROW_NUMBER() OVER(ORDER BY GameID, PopularityScore DESC) FROM #tempProjectPopularity WHERE GameID = @gameId ORDER BY PopularityScore DESC;

		FETCH NEXT FROM gameIds INTO @gameId;
	END;

	-- Clean-up the cursor
	CLOSE gameIds;
	DEALLOCATE gameIds;
	
	MERGE #tempProjectPopularity AS TARGET
	USING #tempProjectGamePopularityRank AS SOURCE
	ON (TARGET.ProjectID = SOURCE.ProjectID)
	WHEN MATCHED THEN 
		UPDATE SET 
			TARGET.GamePopularityRank = SOURCE.GamePopularityRank;

	-- Merge on the final table
	MERGE dbo.Project AS TARGET
	USING #tempProjectPopularity AS SOURCE
	ON (SOURCE.ProjectID = TARGET.ID)
	WHEN MATCHED AND TARGET.PopularityScore != SOURCE.PopularityScore or TARGET.PopularityRank != SOURCE.PopularityRank or TARGET.GamePopularityRank != SOURCE.GamePopularityRank THEN
		UPDATE SET 
			TARGET.PopularityScore = SOURCE.PopularityScore,
			TARGET.PopularityRank = SOURCE.PopularityRank,
			TARGET.GamePopularityRank = SOURCE.GamePopularityRank,
			TARGET.DatePopularityModified = GETUTCDATE();

	DROP TABLE #tempProjectGamePopularityRank;
	DROP TABLE #tempProjectPopularity;	
END

GO

